using System;
using System.Text;
using System.Management.Automation;
using System.Management.Automation.Provider;
using System.Management;
using System.Net.NetworkInformation;

namespace de.ITVisions.PowerShell
{


 [Cmdlet(VerbsCommon.Get, "Disk")]
 public class GetDiskCommand : PSCmdlet
 {
  //   [Parameter()]
  //[Parameter(Position = 0, ValueFromPipeline = true)]

  [Parameter(Position = 0, ValueFromPipeline = true, HelpMessage = "The name or IP address of the Computer.")]
  public string Computer = ".";

  protected override void BeginProcessing()
  {
  }

  protected override void ProcessRecord()
  {
   this.WriteVerbose("Start Processing. Computer = " + this.Computer);

   // Check if computer is reachable
   if (Computer != ".")
   {
    System.Net.NetworkInformation.Ping ping = new System.Net.NetworkInformation.Ping();
    PingReply reply = ping.Send(Computer);
    if (reply.Status != IPStatus.Success) this.WriteWarning("Cannot ping computer!");
   }

   // define WQL query
   string ABFRAGE = "Select * from Win32_Logicaldisk";

   this.WriteVerbose("Defining WQL query...");
   System.Management.ManagementObjectCollection DiskMenge = null;
   ManagementScope ms = new ManagementScope("\\\\" + Computer + "\\root\\cimv2");
   this.WriteDebug("Scope = " + ms.Path);
   ObjectQuery oq = new ObjectQuery(ABFRAGE);
   this.WriteDebug("Query = " + ms.Path);
   System.Management.ManagementObjectSearcher suche = new System.Management.ManagementObjectSearcher(ms, oq);
   
   // Run WQL query
   this.WriteVerbose("Starting WQL query...");
   try
   {
    DiskMenge = suche.Get();
   }
   catch (Exception ex)
   {
    ErrorRecord er = new ErrorRecord(ex, "WQL Query Error", ErrorCategory.ResourceUnavailable, Computer);
    this.WriteError(er);
   }


   if (DiskMenge != null)
   {
    this.WriteDebug("Count = " + DiskMenge.Count);
    // Put objects to pipeline
    this.WriteObject(DiskMenge, true);
   }

   // Alternative
   //foreach (ManagementObject Disk in DiskMenge)
   //{
   // this.WriteObject(Disk);
   //}

   this.WriteVerbose("Finished Processing. Computer = " + this.Computer);
  }

  protected override void StopProcessing()
  {
  }

 }
}
